/*
 * Decompiled with CFR 0.152.
 */
package io.github.g00fy2.versioncompare;

import io.github.g00fy2.versioncompare.VersionComparator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version
implements Comparable<Version> {
    @Nullable
    private final String originalString;
    @NotNull
    private final @NotNull List<@NotNull Long> subversionNumbers = new ArrayList<Long>();
    @NotNull
    private final @NotNull List<@NotNull Long> trimmedSubversionNumbers = new ArrayList<Long>();
    @NotNull
    private final String suffix;
    @NotNull
    private final VersionComparator.ReleaseType releaseType;
    private final long preReleaseVersion;

    public Version(@Nullable String versionString) {
        this(versionString, false);
    }

    public Version(@Nullable String versionString, boolean throwExceptions) {
        if (throwExceptions) {
            if (versionString == null) {
                throw new IllegalArgumentException("Argument versionString is null");
            }
            if (!VersionComparator.startsNumeric(versionString)) {
                throw new IllegalArgumentException("Argument versionString is no valid version");
            }
        }
        this.originalString = versionString;
        if (this.originalString != null && VersionComparator.startsNumeric(this.originalString)) {
            String[] versionTokens = this.originalString.replaceAll("\\s", "").split("\\.");
            boolean suffixFound = false;
            StringBuilder suffixSb = null;
            block0: for (String versionToken : versionTokens) {
                if (suffixFound) {
                    suffixSb.append(".");
                    suffixSb.append(versionToken);
                    continue;
                }
                if (VersionComparator.isNumeric(versionToken)) {
                    this.subversionNumbers.add(VersionComparator.safeParseLong(versionToken));
                    continue;
                }
                for (int i = 0; i < versionToken.length(); ++i) {
                    if (Character.isDigit(versionToken.charAt(i))) continue;
                    suffixSb = new StringBuilder();
                    if (i > 0) {
                        this.subversionNumbers.add(VersionComparator.safeParseLong(versionToken.substring(0, i)));
                        suffixSb.append(versionToken.substring(i));
                    } else {
                        suffixSb.append(versionToken);
                    }
                    suffixFound = true;
                    continue block0;
                }
            }
            this.suffix = suffixSb != null ? suffixSb.toString() : "";
            this.trimmedSubversionNumbers.addAll(this.subversionNumbers);
            while (!this.trimmedSubversionNumbers.isEmpty() && this.trimmedSubversionNumbers.lastIndexOf(0L) == this.trimmedSubversionNumbers.size() - 1) {
                this.trimmedSubversionNumbers.remove(this.trimmedSubversionNumbers.lastIndexOf(0L));
            }
        } else {
            this.suffix = "";
        }
        this.releaseType = VersionComparator.qualifierToReleaseType(this.suffix);
        this.preReleaseVersion = VersionComparator.preReleaseVersion(this.suffix, this.releaseType);
    }

    public long getMajor() {
        return this.trimmedSubversionNumbers.size() > 0 ? this.trimmedSubversionNumbers.get(0) : 0L;
    }

    public long getMinor() {
        return this.trimmedSubversionNumbers.size() > 1 ? this.trimmedSubversionNumbers.get(1) : 0L;
    }

    public long getPatch() {
        return this.trimmedSubversionNumbers.size() > 2 ? this.trimmedSubversionNumbers.get(2) : 0L;
    }

    @NotNull
    public @NotNull List<@NotNull Long> getSubversionNumbers() {
        return this.subversionNumbers;
    }

    @NotNull
    public String getSuffix() {
        return this.suffix;
    }

    @Nullable
    public String getOriginalString() {
        return this.originalString;
    }

    public boolean isHigherThan(String otherVersion) {
        return this.isHigherThan(new Version(otherVersion));
    }

    public boolean isHigherThan(Version otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    public boolean isLowerThan(String otherVersion) {
        return this.isLowerThan(new Version(otherVersion));
    }

    public boolean isLowerThan(Version otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public boolean isEqual(String otherVersion) {
        return this.isEqual(new Version(otherVersion));
    }

    public boolean isEqual(Version otherVersion) {
        return this.compareTo(otherVersion) == 0;
    }

    public boolean isAtLeast(String otherVersion) {
        return this.isAtLeast(new Version(otherVersion));
    }

    public boolean isAtLeast(Version otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean isAtLeast(String otherVersion, boolean ignoreSuffix) {
        return this.isAtLeast(new Version(otherVersion), ignoreSuffix);
    }

    public boolean isAtLeast(Version otherVersion, boolean ignoreSuffix) {
        return this.compareTo(otherVersion, ignoreSuffix) >= 0;
    }

    @Override
    public final int compareTo(@NotNull Version version) {
        return this.compareTo(version, false);
    }

    private int compareTo(@NotNull Version version, boolean ignoreSuffix) {
        int versionNumberResult = VersionComparator.compareSubversionNumbers(this.trimmedSubversionNumbers, version.trimmedSubversionNumbers);
        if (versionNumberResult != 0 || ignoreSuffix) {
            return versionNumberResult;
        }
        int releaseTypeResult = this.releaseType.compareTo(version.releaseType);
        if (releaseTypeResult != 0) {
            return releaseTypeResult;
        }
        return Long.compare(this.preReleaseVersion, version.preReleaseVersion);
    }

    public final boolean equals(Object o) {
        if (o instanceof Version && this.isEqual((Version)o)) {
            return true;
        }
        return super.equals(o);
    }

    public final int hashCode() {
        int result = this.trimmedSubversionNumbers.hashCode();
        result = 31 * result + this.releaseType.hashCode();
        result = 31 * result + (int)(this.preReleaseVersion ^ this.preReleaseVersion >>> 32);
        return result;
    }

    public String toString() {
        return String.valueOf(this.originalString);
    }
}

