/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap;

import java.io.IOException;
import java.nio.file.Paths;
import ru.smclabs.bootstrap.Bootstrap;
import ru.smclabs.bootstrap.util.RuntimeUtils;

public class BootstrapMain {
    public static void main(String[] args) {
        System.out.println("Launcher is started");
        if (BootstrapMain.switchToSystemRuntime()) {
            System.exit(0);
            return;
        }
        try {
            Bootstrap bootstrap = new Bootstrap();
            BootstrapMain.createShutdownHook(bootstrap);
            bootstrap.start();
        }
        catch (Throwable e) {
            Bootstrap.getReportProvider().send("Bootstrap starting", e);
        }
    }

    private static void createShutdownHook(Bootstrap bootstrap) {
        Thread thread = new Thread(bootstrap::stop);
        thread.setName("ShutdownHook Thread");
        Runtime.getRuntime().addShutdownHook(thread);
    }

    private static boolean switchToSystemRuntime() {
        if (RuntimeUtils.isExecutableFileExtension("jar")) {
            return false;
        }
        if (RuntimeUtils.isStartedByWrongPackagedJre()) {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.redirectErrorStream(true);
            processBuilder.command(Paths.get(System.getProperty("user.dir") + "/runtime/x64/bin/java", new String[0]).toString(), "-jar", "Bootstrap.exe");
            try {
                processBuilder.start();
                return true;
            }
            catch (IOException e) {
                Bootstrap.getReportProvider().send("Switch to bundle runtime", e);
            }
        }
        return false;
    }
}

