/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import javax.swing.JFrame;
import ru.smclabs.bootstrap.Bootstrap;
import ru.smclabs.bootstrap.environment.GuiEnvironment;
import ru.smclabs.bootstrap.service.AbstractService;
import ru.smclabs.bootstrap.service.gui.ThemeManager;
import ru.smclabs.bootstrap.service.gui.component.FrameDragListener;
import ru.smclabs.bootstrap.service.gui.panel.PanelBackground;
import ru.smclabs.bootstrap.util.LocalResourceHelper;

public class GuiService
extends AbstractService {
    private final ThemeManager themeManager = new ThemeManager();
    private final JFrame frame = this.createFrame();
    private final PanelBackground panelBackground = new PanelBackground(this);

    public GuiService(Bootstrap bootstrap) {
        super(bootstrap);
        this.frame.setContentPane(this.panelBackground);
    }

    private JFrame createFrame() {
        GuiEnvironment guiEnvironment = this.getBootstrap().getEnvironment().getGui();
        try {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = defaultToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(defaultToolkit, guiEnvironment.getFrameTitle());
        }
        catch (Throwable defaultToolkit) {
            // empty catch block
        }
        JFrame frame = new JFrame();
        frame.setTitle(guiEnvironment.getFrameTitle());
        frame.setName(guiEnvironment.getFrameTitle());
        frame.setPreferredSize(new Dimension(guiEnvironment.getFrameWidth(), guiEnvironment.getFrameHeight()));
        frame.setIconImage(LocalResourceHelper.loadScaledImage("/assets/icons/512.png", 128, 128));
        frame.setDefaultCloseOperation(3);
        frame.setUndecorated(true);
        frame.setResizable(false);
        frame.setBackground(new Color(0, 0, 0, 0));
        FrameDragListener dragListener = new FrameDragListener(frame);
        frame.addMouseListener(dragListener);
        frame.addMouseMotionListener(dragListener);
        return frame;
    }

    public void postInit() {
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public PanelBackground getPanelBackground() {
        return this.panelBackground;
    }
}

