/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.gui.component.button;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import ru.smclabs.bootstrap.Bootstrap;
import ru.smclabs.bootstrap.service.gui.ThemeManager;
import ru.smclabs.bootstrap.util.LocalResourceHelper;

public abstract class ButtonControl
extends JComponent
implements MouseListener {
    private final Image imageRegular;
    private final Image imageHover;
    private boolean hovered = false;

    public ButtonControl(ThemeManager themeManager, String type) {
        this.setPreferredSize(new Dimension(40, 40));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.imageRegular = themeManager.getImage("buttons", type, 40, 40);
        this.imageHover = LocalResourceHelper.loadScaledImage("/assets/buttons/" + type + "-hover.png", 40, 40);
        this.addMouseListener(this);
    }

    @Override
    public abstract void mouseClicked(MouseEvent var1);

    @Override
    protected void paintComponent(Graphics g) {
        Dimension dimension = this.getPreferredSize().getSize();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Bootstrap.getInstance().getGuiService().getThemeManager().getColor("bg"));
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, dimension.width, dimension.height, 0.0, 0.0));
        g2d.drawImage(this.hovered ? this.imageHover : this.imageRegular, 0, 0, dimension.width, dimension.height, this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hovered = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hovered = false;
        this.repaint();
    }
}

