/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.gui.panel;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import ru.smclabs.bootstrap.service.GuiService;
import ru.smclabs.bootstrap.service.gui.component.BorderBackground;
import ru.smclabs.bootstrap.service.gui.panel.AbstractPanel;
import ru.smclabs.bootstrap.service.gui.panel.PanelHeader;
import ru.smclabs.bootstrap.service.gui.panel.PanelUpdate;
import ru.smclabs.bootstrap.util.LocalResourceHelper;

public class PanelBackground
extends AbstractPanel {
    public static final int PADDING_X = 34;
    public static final int PADDING_Y = 28;
    private static final int LOGO_WIDTH = 40;
    private static final int LOGO_HEIGHT = 40;
    private final Image imageLogo = LocalResourceHelper.loadScaledImage("/assets/icons/512.png", 40, 40);
    private final PanelUpdate panelUpdate;

    public PanelBackground(GuiService guiService) {
        super(guiService);
        this.setLayout(null);
        this.setBackground(null);
        this.setBorder(new BorderBackground(guiService.getThemeManager()));
        this.add(new PanelHeader(guiService));
        this.panelUpdate = new PanelUpdate(guiService);
        this.add(this.panelUpdate);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBackground(g2d);
        this.drawLogo(g2d);
        super.paintComponent(g);
    }

    private void drawBackground(Graphics2D g2d) {
        g2d.setColor(this.guiService.getThemeManager().getColor("bg"));
        g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), Math.PI * 9, Math.PI * 9));
    }

    private void drawLogo(Graphics2D g2d) {
        g2d.drawImage(this.imageLogo, 34, 28, 40, 40, this);
    }

    public PanelUpdate getPanelUpdate() {
        return this.panelUpdate;
    }
}

