/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.launcher.process;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import ru.smclabs.bootstrap.service.launcher.exception.LauncherServiceException;
import ru.smclabs.jacksonpack.Jackson;
import ru.smclabs.slauncher.resources.provider.DirProvider;
import ru.smclabs.system.exception.SystemException;
import ru.smclabs.system.process.ProcessActions;
import ru.smclabs.system.process.ProcessId;

public class LauncherProcess {
    @JsonProperty
    private UUID uuid;
    @JsonProperty
    private Long pid;
    @JsonIgnore
    private List<String> params = new ArrayList<String>();
    @JsonIgnore
    private Process process;
    @JsonIgnore
    private Path file;

    public LauncherProcess(DirProvider dirProvider, Path executableBinary) {
        this.uuid = UUID.randomUUID();
        this.file = Paths.get(dirProvider.getPersistenceDir("data/process/launcher") + "/" + this.uuid + ".json", new String[0]);
        this.addParam(executableBinary.toString()).addSystemParam("puid", this.uuid);
    }

    public LauncherProcess(Path file) throws LauncherServiceException {
        this.readFromDisk(file);
    }

    protected Process getProcess() {
        return this.process;
    }

    public LauncherProcess addParam(String param) {
        if (this.process != null) {
            throw new IllegalStateException("Game process is already created!");
        }
        this.params.add(param);
        return this;
    }

    public LauncherProcess addSystemParam(String key, Object value) {
        return this.addParam("-D" + key + "=" + value);
    }

    public void start(DirProvider dirProvider) throws LauncherServiceException {
        ProcessBuilder builder = new ProcessBuilder(this.params);
        builder.directory(dirProvider.getPersistenceDir().toFile());
        builder.redirectErrorStream(true);
        builder.environment().put("_JAVA_OPTIONS", "");
        try {
            this.process = builder.start();
            this.pid = ProcessId.from(this.process);
            this.writeToDisk();
        }
        catch (Throwable e) {
            this.destroy();
            throw new LauncherServiceException("Failed to start process!", e);
        }
    }

    public void destroy() throws LauncherServiceException {
        try {
            if (this.process != null) {
                this.process.destroy();
            } else if (this.pid != null) {
                ProcessActions.kill(this.pid);
            }
        }
        catch (SystemException e) {
            throw new LauncherServiceException("Failed to destroy process!", e);
        }
        finally {
            this.removeFromDisk();
        }
    }

    public void removeFromDisk() throws LauncherServiceException {
        try {
            Files.deleteIfExists(this.file);
        }
        catch (IOException e) {
            throw new LauncherServiceException("Failed to remove launcher process data!", e);
        }
    }

    public void writeToDisk() throws LauncherServiceException {
        try {
            Files.write(this.file, Jackson.getMapper().writeValueAsString(this).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new LauncherServiceException("Failed to write launcher process data!", e);
        }
    }

    public void readFromDisk(Path path) throws LauncherServiceException {
        this.file = path;
        try {
            LauncherProcess process = Jackson.getMapper().readValue(path.toFile(), LauncherProcess.class);
            this.pid = process.getPid();
            this.uuid = process.getUuid();
        }
        catch (IOException e) {
            throw new LauncherServiceException("Failed to read launcher process data!", e);
        }
    }

    public String toString() {
        return "LauncherProcess(uuid=" + this.getUuid() + ", pid=" + this.getPid() + ", params=" + this.params + ", process=" + this.getProcess() + ", file=" + this.file + ")";
    }

    public LauncherProcess() {
    }

    public LauncherProcess(UUID uuid, Long pid, List<String> params, Process process, Path file) {
        this.uuid = uuid;
        this.pid = pid;
        this.params = params;
        this.process = process;
        this.file = file;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Long getPid() {
        return this.pid;
    }
}

