/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import ru.smclabs.bootstrap.Bootstrap;
import ru.smclabs.bootstrap.service.ResourcesService;
import ru.smclabs.bootstrap.service.gui.panel.PanelUpdate;
import ru.smclabs.bootstrap.service.launcher.ProcessManager;
import ru.smclabs.bootstrap.service.launcher.exception.LauncherProcessFailedException;
import ru.smclabs.bootstrap.service.launcher.exception.LauncherServiceException;
import ru.smclabs.bootstrap.service.launcher.process.LauncherProcess;
import ru.smclabs.bootstrap.service.launcher.process.LauncherProcessTracker;
import ru.smclabs.bootstrap.service.resource.BootstrapResourcesFactory;
import ru.smclabs.bootstrap.service.resource.ResourcesBuild;
import ru.smclabs.bootstrap.service.resource.download.ResourceDownloadTask;
import ru.smclabs.bootstrap.service.resource.download.ResourceDownloadTaskStats;
import ru.smclabs.bootstrap.service.resource.dto.BootstrapResourceList;
import ru.smclabs.bootstrap.service.resource.exception.ResourceServerException;
import ru.smclabs.bootstrap.service.resource.exception.ResourceWriteException;
import ru.smclabs.bootstrap.service.resource.type.ResourceLauncher;
import ru.smclabs.bootstrap.util.report.BootstrapReportProvider;
import ru.smclabs.slauncher.http.HttpService;
import ru.smclabs.slauncher.http.exception.HttpServiceException;
import ru.smclabs.slauncher.http.request.HttpRequest;
import ru.smclabs.slauncher.resources.exception.ResourceException;
import ru.smclabs.slauncher.resources.type.ResourceCompressed;
import ru.smclabs.slauncher.resources.type.ResourceCompressedRuntime;

public class ResourcesUpdateTask {
    private final BootstrapResourcesFactory factory = new BootstrapResourcesFactory();
    private final PanelUpdate panelUpdate;
    private final ResourcesService service;
    private final Thread thread;

    public ResourcesUpdateTask(ResourcesService service, PanelUpdate panelUpdate) {
        this.service = service;
        this.panelUpdate = panelUpdate;
        this.thread = this.createThread();
    }

    private Thread createThread() {
        Thread thread = new Thread(() -> {
            try {
                this.update();
            }
            catch (InterruptedException e) {
                Bootstrap.getInstance().getLogger().info("Update cancelled.", new Object[0]);
            }
            finally {
                this.service.cancelTask();
            }
        });
        thread.setName("ResourceUpdateTask Thread");
        return thread;
    }

    private void retryUpdate() throws InterruptedException {
        TimeUnit.SECONDS.sleep(5L);
        for (int i = 0; i < 5; ++i) {
            this.panelUpdate.setLabelSubTitle("\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0447\u0435\u0440\u0435\u0437 " + (5 - i) + " \u0441\u0435\u043a");
            TimeUnit.SECONDS.sleep(1L);
        }
        this.update();
    }

    private void update() throws InterruptedException {
        try {
            this.run();
        }
        catch (LauncherProcessFailedException e) {
            BootstrapReportProvider reportProvider = Bootstrap.getReportProvider();
            String reportPayload = reportProvider.createReport(e) + "\n\nLauncher process output:\n" + e.getProcessOutput();
            reportProvider.send("Launcher process startup", reportPayload);
            this.panelUpdate.setLabelTitle("\u0427\u0442\u043e-\u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a");
            this.panelUpdate.setLabelSubTitle("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043b\u0430\u0443\u043d\u0447\u0435\u0440");
            this.retryUpdate();
        }
        catch (JsonProcessingException | LauncherServiceException | ResourceServerException | ResourceWriteException | HttpServiceException | ResourceException e) {
            Bootstrap.getReportProvider().send("Bootstrap update process", e);
            this.panelUpdate.setLabelTitle("\u0427\u0442\u043e-\u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a");
            this.panelUpdate.setLabelSubTitle("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043b\u0430\u0443\u043d\u0447\u0435\u0440");
            this.retryUpdate();
        }
    }

    private void run() throws HttpServiceException, JsonProcessingException, ResourceWriteException, ResourceServerException, InterruptedException, LauncherServiceException {
        ResourcesBuild resourcesBuild = this.factory.buildModels(this.fetchResourceList());
        ResourceCompressedRuntime runtime = resourcesBuild.getResources().stream().filter(resource -> resource instanceof ResourceCompressedRuntime).findFirst().map(ResourceCompressedRuntime.class::cast).orElseThrow(() -> new ResourceException("Runtime not found!"));
        ResourceLauncher launcher = resourcesBuild.getResources().stream().filter(resource -> resource instanceof ResourceLauncher).findFirst().map(ResourceLauncher.class::cast).orElseThrow(() -> new ResourceException("Launcher not found!"));
        this.downloadInvalidFiles(resourcesBuild, runtime, launcher);
        this.removeOldLauncherVersions(runtime, launcher);
        this.panelUpdate.setLabelTitle("\u0412\u0441\u0435 \u0433\u043e\u0442\u043e\u0432\u043e");
        this.panelUpdate.setLabelSubTitle("\u0437\u0430\u043f\u0443\u0441\u043a \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430...");
        this.checkIfCancelled();
        LauncherProcess launcherProcess = Bootstrap.getInstance().getLauncherService().getProcessManager().create(launcher.getPath(), runtime.getExecutableBinary());
        LauncherProcessTracker launcherProcessTracker = new LauncherProcessTracker(this, launcherProcess);
        launcherProcessTracker.track();
        System.exit(0);
    }

    private BootstrapResourceList fetchResourceList() throws HttpServiceException, JsonProcessingException {
        HttpRequest<HttpService, BootstrapResourceList> request = new HttpRequest<HttpService, BootstrapResourceList>(Bootstrap.getInstance().getHttpService(), "GET", "application/json", "%slauncher-backend%/bootstrap");
        return request.execute(BootstrapResourceList.class);
    }

    private void removeOldLauncherVersions(ResourceCompressedRuntime runtime, ResourceLauncher launcher) throws InterruptedException {
        ProcessManager processManager = Bootstrap.getInstance().getLauncherService().getProcessManager();
        processManager.readProcessesFromDisk();
        processManager.destroyLauncherProcesses(runtime, launcher);
        TimeUnit.SECONDS.sleep(1L);
        launcher.removeOlderVersions();
    }

    private void downloadInvalidFiles(ResourcesBuild resourcesBuild, ResourceCompressedRuntime runtime, ResourceLauncher launcher) throws InterruptedException, ResourceWriteException, ResourceServerException, HttpServiceException {
        List<ResourceDownloadTask> downloads = resourcesBuild.findInvalidResources();
        if (!downloads.isEmpty()) {
            ProcessManager processManager = Bootstrap.getInstance().getLauncherService().getProcessManager();
            processManager.readProcessesFromDisk();
            processManager.destroyLauncherProcesses(runtime, launcher);
            TimeUnit.SECONDS.sleep(1L);
            ArrayList<ResourceCompressed> compressedResources = new ArrayList<ResourceCompressed>();
            try (ResourceDownloadTaskStats stats = new ResourceDownloadTaskStats(this.panelUpdate);){
                this.panelUpdate.setLabelTitle("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435");
                this.panelUpdate.setLabelSubTitle("\u0441\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f...");
                this.panelUpdate.setLabelTimeRemain("...");
                this.panelUpdate.setLabelFileName("...");
                this.panelUpdate.setLabelSpeed("...");
                this.panelUpdate.setProgress(0.0);
                this.panelUpdate.setFileDownloadingVisible(true);
                stats.start(downloads.stream().mapToLong(task -> task.getResource().getSize()).sum());
                for (ResourceDownloadTask download : downloads) {
                    this.panelUpdate.setLabelFileName(download.getResource().getName());
                    download.setStats(stats);
                    download.run();
                    if (!(download.getResource() instanceof ResourceCompressed)) continue;
                    compressedResources.add((ResourceCompressed)download.getResource());
                }
            }
            this.panelUpdate.setLabelSubTitle("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f...");
            this.panelUpdate.setProgress(-1.0);
            this.panelUpdate.setFileDownloadingVisible(false);
            for (ResourceCompressed resource : compressedResources) {
                this.checkIfCancelled();
                resource.extract();
            }
        }
    }

    public void start() {
        this.thread.start();
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    public boolean isCancelled() {
        return this.thread.isInterrupted();
    }

    public void checkIfCancelled() throws InterruptedException {
        if (this.isCancelled()) {
            throw new InterruptedException("Update cancelled by user");
        }
    }

    public PanelUpdate getPanelUpdate() {
        return this.panelUpdate;
    }
}

