/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.service.resource.download;

import java.util.concurrent.TimeUnit;
import ru.smclabs.bootstrap.service.gui.panel.PanelUpdate;
import ru.smclabs.bootstrap.util.TimeUtils;
import ru.smclabs.slauncher.resources.util.FileUtils;

public class ResourceDownloadTaskStats
implements AutoCloseable {
    private final PanelUpdate panelUpdate;
    private final Thread thread;
    private long bytesMustBeRead;
    private long bytesRead;

    public ResourceDownloadTaskStats(PanelUpdate panelUpdate) {
        this.panelUpdate = panelUpdate;
        this.thread = new Thread(() -> {
            try {
                this.update();
            }
            catch (InterruptedException e) {
                this.close();
            }
        });
        this.thread.setName("ResourceDownloadTaskStats Thread");
        this.thread.setDaemon(true);
    }

    public void start(long bytesMustBeRead) {
        this.bytesMustBeRead = bytesMustBeRead;
        this.thread.start();
    }

    private void update() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long bytesReadedLast = 0L;
        long remainingTime = 0L;
        while (this.canTick()) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis % 100L == 0L) {
                long bytesReadCopy = this.bytesRead;
                double progress = (double)(bytesReadCopy >> 10) / (double)(this.bytesMustBeRead >> 10);
                if (bytesReadCopy > 0L && this.bytesMustBeRead > 0L) {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    remainingTime = elapsedTime * this.bytesMustBeRead / bytesReadCopy - elapsedTime;
                }
                this.panelUpdate.setProgress(progress);
            }
            if (currentTimeMillis % 1000L != 0L) continue;
            long bytesDifference = this.bytesRead - bytesReadedLast;
            bytesReadedLast = this.bytesRead;
            this.panelUpdate.setLabelSpeed(FileUtils.humanSize(bytesDifference) + "/\u0441\u0435\u043a ~");
            this.panelUpdate.setLabelTimeRemain(TimeUtils.toHumanTime(Math.max(1000L, remainingTime)) + " ~");
        }
    }

    private boolean canTick() {
        try {
            TimeUnit.MILLISECONDS.sleep(1L);
            return true;
        }
        catch (InterruptedException e) {
            this.close();
            return false;
        }
    }

    public void addReadBytes(int bytesRead) {
        this.bytesRead += (long)bytesRead;
    }

    @Override
    public void close() {
        this.thread.interrupt();
    }
}

