/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import ru.smclabs.bootstrap.util.resource.LocalResourceException;

public class LocalResourceHelper {
    public static URL toUrl(String path) throws LocalResourceException {
        URL url = LocalResourceHelper.class.getResource(path);
        if (url == null) {
            throw new LocalResourceException("Resource not found: " + path);
        }
        return url;
    }

    public static String toUrlExternal(String path) throws LocalResourceException {
        return LocalResourceHelper.toUrl(path).toExternalForm();
    }

    private static BufferedImage loadBufferedImage(String path) throws LocalResourceException {
        try {
            return ImageIO.read(LocalResourceHelper.toUrl(path));
        }
        catch (Throwable e) {
            throw new LocalResourceException("Failed to load local image!", e);
        }
    }

    public static Image loadScaledImage(String path, int width, int height) {
        return LocalResourceHelper.loadBufferedImage(path).getScaledInstance(width, height, 4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Font loadFont(String name, float size) {
        try (InputStream inputStream = LocalResourceHelper.toUrl("/assets/fonts/" + name + ".ttf").openStream();){
            Font font = Font.createFont(0, inputStream).deriveFont(size);
            return font;
        }
        catch (Throwable e) {
            Font[] fonts;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font : fonts = ge.getAllFonts()) {
                if (!font.getName().equals(name)) continue;
                return font.deriveFont(size);
            }
            Font[] fontArray = fonts;
            int n = fontArray.length;
            int n2 = 0;
            while (n2 < n) {
                Font font;
                font = fontArray[n2];
                if (font.getName().startsWith(name)) {
                    return font.deriveFont(size);
                }
                ++n2;
            }
            return new Font(null, 0, (int)size);
        }
    }
}

