/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.bootstrap.util;

import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import ru.smclabs.bootstrap.BootstrapMain;
import ru.smclabs.system.info.SystemInfo;

public class RuntimeUtils {
    public static Path getWorkingDir() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public static boolean isStartedByWrongPackagedJre() {
        return RuntimeUtils.isStartedByPackagedJre() && SystemInfo.get().isX64() && !System.getProperty("os.arch").contains("64");
    }

    public static boolean isStartedByPackagedJre() {
        return SystemInfo.get().isWindows() && Files.exists(Paths.get(RuntimeUtils.getWorkingDir() + "/runtime/", new String[0]), new LinkOption[0]);
    }

    public static Path getExecutableFilePath() throws URISyntaxException {
        return Paths.get(BootstrapMain.class.getProtectionDomain().getCodeSource().getLocation().toURI());
    }

    public static String getExecutableFileName() {
        try {
            return RuntimeUtils.getExecutableFilePath().getFileName().toString();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static boolean isExecutableFileExtension(String extension) {
        return RuntimeUtils.getExecutableFileName().endsWith("." + extension);
    }
}

