/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.report.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Base64;
import lombok.Generated;
import ru.smclabs.report.api.provider.ReportException;

public class Report {
    private final Type type;
    private final String context;
    private final String payload;

    @JsonCreator
    private Report(@JsonProperty(value="type") Type type, @JsonProperty(value="context") String context, @JsonProperty(value="payload") String payload) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null!");
        }
        if (payload == null || payload.isEmpty()) {
            throw new IllegalArgumentException("Payload must not be null or empty!");
        }
        this.type = type;
        this.context = context;
        this.payload = payload;
    }

    public static Report of(Type type, String context, Path file) throws ReportException {
        if (Files.notExists(file, new LinkOption[0])) {
            throw new ReportException("File not found!");
        }
        try {
            return Report.of(type, context, Files.readAllBytes(file));
        }
        catch (IOException e) {
            throw new ReportException("Failed to read file!", e);
        }
    }

    public static Report of(Type type, String context, Throwable throwable) {
        StringWriter buffer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(buffer);){
            throwable.printStackTrace(pw);
            Report report = Report.of(type, context, buffer.toString().getBytes(StandardCharsets.UTF_8));
            return report;
        }
    }

    public static Report of(Type type, String context, String payload) {
        return Report.of(type, context, payload.getBytes(StandardCharsets.UTF_8));
    }

    public static Report of(Type type, String context, byte[] payload) {
        return new Report(type, context, Base64.getEncoder().encodeToString(payload));
    }

    public String toString() {
        return "Report(type=" + (Object)((Object)this.getType()) + ", context=" + this.getContext() + ")";
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    public static enum Type {
        LAUNCHER,
        SERVER,
        CLIENT;

    }
}

