/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.report.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import ru.smclabs.report.api.Report;
import ru.smclabs.report.api.provider.IReportProvider;
import ru.smclabs.report.api.provider.ReportException;
import ru.smclabs.report.impl.HttpEnvironment;

public abstract class HttpReportProvider
implements IReportProvider {
    private final HttpEnvironment environment = new HttpEnvironment();

    protected abstract String reportToJson(Report var1) throws ReportException;

    @Override
    public void send(Report report) throws ReportException {
        byte[] content = this.reportToJson(report).getBytes(StandardCharsets.UTF_8);
        try {
            this.sendRequest(this.environment.getEndpoint(), content);
        }
        catch (IOException e) {
            for (int endpointIndex = 0; endpointIndex < this.environment.getEndpointsLength(); ++endpointIndex) {
                for (int protocolIndex = 0; protocolIndex < this.environment.getProtocolsLength(); ++protocolIndex) {
                    String endpoint = this.environment.getEndpoint(endpointIndex, protocolIndex);
                    try {
                        this.sendRequest(endpoint, content);
                        return;
                    }
                    catch (IOException e2) {
                        e.addSuppressed(e2);
                        continue;
                    }
                }
            }
            throw new ReportException("Failed to send report!", e);
        }
    }

    private void sendRequest(String endpoint, byte[] report) throws IOException {
        HttpURLConnection connection = this.openConnection(endpoint);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        connection.setRequestProperty("Content-Length", String.valueOf(report.length));
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(report);
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to send report! Response code: " + connection.getResponseCode());
        }
    }

    private HttpURLConnection openConnection(String endpoint) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(endpoint).openConnection();
        connection.setConnectTimeout(2500);
        connection.setReadTimeout(2500);
        connection.setUseCaches(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", this.environment.getUserAgent());
        return connection;
    }
}

