/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.http.exception;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDateTime;
import lombok.Generated;
import ru.smclabs.jacksonpack.Jackson;
import ru.smclabs.slauncher.http.exception.HttpServiceException;
import ru.smclabs.slauncher.http.exception.IHasMessageResponse;
import ru.smclabs.slauncher.http.response.HttpResponse;
import ru.smclabs.slauncher.http.response.type.MessageResponse;

public class HttpServerException
extends HttpServiceException
implements IHasMessageResponse {
    private final int statusCode;

    public HttpServerException(HttpResponse response, Throwable cause) {
        super(response.getResponseBody(), cause);
        this.statusCode = response.getResponseCode();
    }

    public HttpServerException(HttpResponse response) {
        super(response.getResponseBody());
        this.statusCode = response.getResponseCode();
    }

    @Override
    public MessageResponse toMessageResponse() {
        try {
            return Jackson.getMapper().readValue(this.getMessage(), MessageResponse.class);
        }
        catch (JsonProcessingException e) {
            MessageResponse response = new MessageResponse();
            response.setTime(LocalDateTime.now().toString());
            response.setType(this.getClass().getSimpleName());
            response.setStatus(this.getStatusCode());
            response.setMessage(this.getMessage());
            return response;
        }
    }

    @Generated
    public int getStatusCode() {
        return this.statusCode;
    }
}

