/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.http.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import ru.smclabs.jacksonpack.Jackson;
import ru.smclabs.slauncher.http.HttpService;
import ru.smclabs.slauncher.http.environment.HttpEnvironment;
import ru.smclabs.slauncher.http.exception.HttpAuthException;
import ru.smclabs.slauncher.http.exception.HttpClientException;
import ru.smclabs.slauncher.http.exception.HttpServerException;
import ru.smclabs.slauncher.http.exception.HttpServiceException;
import ru.smclabs.slauncher.http.response.HttpResponse;
import ru.smclabs.slauncher.util.logger.ILogger;

public class HttpRequest<S extends HttpService, T> {
    protected final S httpService;
    protected final String method;
    protected final String contentType;
    protected final String path;
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected String requestBody;
    protected URL url;

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setRequestBody(Object body) throws JsonProcessingException {
        if (body instanceof String) {
            this.requestBody = (String)body;
            return;
        }
        this.requestBody = Jackson.getMapper().writeValueAsString(body);
    }

    public T execute(TypeReference<T> typeReference) throws HttpServiceException, JsonProcessingException {
        HttpResponse response = this.sendRequestWithRetry();
        return Jackson.getMapper().readValue(response.getResponseBody(), typeReference);
    }

    public T execute(Class<T> responseClass) throws HttpServiceException, JsonProcessingException {
        HttpResponse response = this.sendRequestWithRetry();
        return responseClass == String.class ? responseClass.cast(response.getResponseBody()) : Jackson.getMapper().readValue(response.getResponseBody(), responseClass);
    }

    public boolean isResponseBodyInvalid(HttpResponse response) {
        if (this.contentType.contains("image")) {
            return false;
        }
        if (this.contentType.contains("json")) {
            return response.getResponseBody().contains("<");
        }
        return false;
    }

    protected HttpResponse sendRequestWithRetry() throws HttpServiceException {
        ILogger logger = ((HttpService)this.httpService).getLogger();
        HttpEnvironment environment = ((HttpService)this.httpService).getEnvironment();
        try {
            return this.sendRequest(logger);
        }
        catch (HttpAuthException e) {
            throw e;
        }
        catch (HttpClientException | HttpServerException e) {
            logger.warn("Failed to send request! (zone: ." + environment.getZone() + ", protocol: " + environment.getProtocol() + ", url: " + this.url + ")", new Object[0]);
            logger.info("Search working zone...", new Object[0]);
            for (int i = 0; i < environment.getZones().size(); ++i) {
                environment.setZoneIndex(i);
                for (int j = 0; j < environment.getProtocols().size(); ++j) {
                    environment.setProtocolIndex(j);
                    logger.info("Try zone: ." + environment.getZone() + ", protocol: " + environment.getProtocol(), new Object[0]);
                    try {
                        HttpResponse response = this.sendRequest(logger);
                        if (this.isResponseBodyInvalid(response)) {
                            throw new HttpServiceException("Response body is invalid!");
                        }
                        logger.info("Found working zone: ." + environment.getZone() + ", protocol: " + environment.getProtocol(), new Object[0]);
                        return response;
                    }
                    catch (HttpServiceException e1) {
                        e.addSuppressed(e1);
                        continue;
                    }
                }
            }
            throw e;
        }
    }

    protected HttpResponse handleAuthException(HttpResponse response, ILogger logger) throws HttpAuthException {
        logger.info("Auth exception handling skipped", new Object[0]);
        throw new HttpAuthException(response);
    }

    protected HttpResponse sendRequest(ILogger logger) throws HttpServiceException {
        HttpURLConnection connection = this.openConnection(this.prepareURL());
        connection.setRequestProperty("Accept", this.contentType);
        this.writeRequestBody(connection);
        HttpResponse response = new HttpResponse(connection);
        response.readStream();
        if (response.getResponseCode() == 200) {
            return response;
        }
        if (response.getResponseCode() == 401) {
            return this.handleAuthException(response, logger);
        }
        throw new HttpServerException(response);
    }

    protected URL prepareURL() throws HttpClientException {
        this.url = ((HttpService)this.httpService).createUrl(this.path);
        return this.url;
    }

    protected HttpURLConnection openConnection(URL url) throws HttpClientException {
        HttpURLConnection connection = ((HttpService)this.httpService).openConnection(url, this.method);
        this.headers.forEach(connection::setRequestProperty);
        return connection;
    }

    protected void writeRequestBody(HttpURLConnection connection) throws HttpClientException {
        if (this.requestBody == null) {
            return;
        }
        if (!this.method.equals("POST") && !this.method.equals("PUT")) {
            throw new HttpClientException("Post request body allowed only with POST method!");
        }
        byte[] bytes = this.requestBody.getBytes(StandardCharsets.UTF_8);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", this.contentType + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new HttpClientException("Failed to write request body!", e);
        }
    }

    @Generated
    public S getHttpService() {
        return this.httpService;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getRequestBody() {
        return this.requestBody;
    }

    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public HttpRequest(S httpService, String method, String contentType, String path) {
        this.httpService = httpService;
        this.method = method;
        this.contentType = contentType;
        this.path = path;
    }
}

