/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.http.response;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import ru.smclabs.slauncher.http.exception.HttpServerException;

public class HttpResponse {
    protected final HttpURLConnection connection;
    protected int responseCode;
    protected String responseBody;

    public void readStream() throws HttpServerException {
        try {
            this.responseCode = this.connection.getResponseCode();
            this.readStream(this.selectInputStream());
        }
        catch (IOException e) {
            if (this.connection.getErrorStream() != null) {
                try {
                    this.readStream(this.connection.getErrorStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new HttpServerException(this, (Throwable)e);
        }
    }

    protected InputStream selectInputStream() throws IOException {
        return this.connection.getErrorStream() != null ? this.connection.getErrorStream() : this.connection.getInputStream();
    }

    protected void readStream(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            this.responseBody = result.toString();
        }
    }

    @Generated
    public HttpURLConnection getConnection() {
        return this.connection;
    }

    @Generated
    public int getResponseCode() {
        return this.responseCode;
    }

    @Generated
    public String getResponseBody() {
        return this.responseBody;
    }

    @Generated
    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    @Generated
    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    @Generated
    public HttpResponse(HttpURLConnection connection) {
        this.connection = connection;
    }
}

