/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.smclabs.slauncher.resources.exception.ResourceException;
import ru.smclabs.slauncher.resources.provider.DirProvider;

public class ResourcesFinder {
    protected final DirProvider dirProvider;

    public ResourcesFinder(DirProvider dirProvider) {
        this.dirProvider = dirProvider;
    }

    public static List<Path> findAllJars(Path clientDir, Path versionDir) {
        ArrayList<Path> files = new ArrayList<Path>();
        files.addAll(ResourcesFinder.findModsJars(clientDir));
        files.addAll(ResourcesFinder.findVersionJars(versionDir));
        return files;
    }

    public static List<Path> findModsJars(Path clientDir) {
        return ResourcesFinder.findFilesByExtension(clientDir.resolve("mods"), ".jar", ".zip", ".litemod");
    }

    public static List<Path> findVersionJars(Path versionDir) {
        return ResourcesFinder.findFilesByExtension(versionDir, ".jar", ".zip", ".litemod");
    }

    public static List<Path> findFilesByExtension(Path dir, String ... extensions) {
        return ResourcesFinder.findFilesByPredicate(dir, (filePath, attributes) -> {
            if (attributes.isRegularFile()) {
                for (String extension : extensions) {
                    if (extension.equals("all")) {
                        return true;
                    }
                    if (!filePath.getFileName().toString().endsWith(extension)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Path> findFilesByPredicate(Path dir, BiPredicate<Path, BasicFileAttributes> predicate) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.find(dir, Integer.MAX_VALUE, predicate, new FileVisitOption[0]);){
            List<Path> list = stream.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }
}

