/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.type;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.smclabs.slauncher.model.resource.ResourceModel;
import ru.smclabs.slauncher.resources.exception.ResourceException;
import ru.smclabs.slauncher.resources.factory.ResourcesFactory;
import ru.smclabs.slauncher.resources.mapper.ResourceMapper;
import ru.smclabs.slauncher.resources.mapper.ResourceMapperEntry;
import ru.smclabs.slauncher.resources.type.Resource;
import ru.smclabs.slauncher.resources.util.CompressedUtils;
import ru.smclabs.slauncher.resources.util.FileUtils;

public class ResourceCompressed
extends Resource {
    @JsonIgnore
    protected ResourceMapper mapper;

    public ResourceCompressed(ResourcesFactory factory, ResourceModel model) {
        super(factory, model);
    }

    @Override
    public boolean isInvalid() {
        try {
            this.mapper.readFromDisk();
        }
        catch (ResourceException e) {
            return true;
        }
        List<ResourceMapperEntry> entries = this.mapper.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        for (ResourceMapperEntry entry : entries) {
            if (entry.getPath().equals(this.path)) {
                if (entry.getData().equals(this.hash)) continue;
                return true;
            }
            if (!Files.exists(entry.getPath(), new LinkOption[0])) {
                return true;
            }
            String entryData = entry.getData();
            if (entryData == null) {
                return true;
            }
            try {
                if (entryData.equals(String.valueOf(Files.size(entry.getPath())))) continue;
                return true;
            }
            catch (IOException e) {
                throw new ResourceException("Failed to check mapper entry size!", e);
            }
        }
        return false;
    }

    public void extract() throws InterruptedException {
        try {
            CompressedUtils.extract(this.path, this.path.getParent());
            FileUtils.deleteFile(this.path, 10);
            this.mapper.clear();
            this.mapper.put(this.path, this.hash);
            for (Path extractedFile : this.getExtractedFiles()) {
                this.mapper.put(extractedFile, Files.size(extractedFile));
            }
            this.mapper.writeToDisk();
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Path> getExtractedFiles() throws ResourceException {
        Path dir = this.path.getParent().resolve(this.getArchiveRootDirName());
        try (Stream<Path> files = Files.find(dir, Integer.MAX_VALUE, (path1, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]);){
            List<Path> list = files.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    protected String getArchiveRootDirName() {
        return this.getName().replace(".tar.gz", "").replace(".tar", "").replace(".zip", "").toLowerCase();
    }

    @JsonIgnore
    public void setMapper(ResourceMapper mapper) {
        this.mapper = mapper;
    }
}

