/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.type;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.smclabs.slauncher.model.resource.ResourceModel;
import ru.smclabs.slauncher.resources.exception.ResourceException;
import ru.smclabs.slauncher.resources.factory.ResourcesFactory;
import ru.smclabs.slauncher.resources.mapper.ResourceMapper;
import ru.smclabs.slauncher.resources.mapper.ResourceMapperEntry;
import ru.smclabs.slauncher.resources.type.ResourceCompressed;

public class ResourceCompressedRuntime
extends ResourceCompressed {
    public ResourceCompressedRuntime(ResourcesFactory factory, ResourceModel model, String version) {
        super(factory, model);
        this.setMapper(new ResourceMapper(factory, this.getArchiveRootDirName() + "-" + version));
    }

    @Override
    public void extract() throws InterruptedException {
        super.extract();
        if (!System.getProperty("os.name", "").toLowerCase().contains("win")) {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            this.getExtractedFiles().forEach(path -> {
                try {
                    Files.setPosixFilePermissions(path, permissions);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<Path> getExtractedFiles() {
        try (Stream<Path> files = Files.find(this.path.getParent(), Integer.MAX_VALUE, (path, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]);){
            List<Path> list = files.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new ResourceException("Failed to collect extracted files!", e);
        }
    }

    public Path getExecutableBinary() {
        Optional<Path> executorPath = this.mapper.getEntries().stream().map(ResourceMapperEntry::getPath).filter(entryPath -> {
            String fileName = entryPath.getFileName().toString();
            return fileName.equals("java") || fileName.equals("java.exe");
        }).findFirst();
        if (!executorPath.isPresent() || !Files.exists(executorPath.get(), new LinkOption[0])) {
            throw new ResourceException("Failed to find executable runtime binary!");
        }
        return executorPath.get();
    }
}

