/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.type;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Path;
import ru.smclabs.slauncher.model.resource.ResourceModel;
import ru.smclabs.slauncher.resources.factory.ResourcesFactory;

public class ResourceStruct {
    @JsonProperty
    protected String name;
    @JsonProperty
    protected String hash;
    @JsonProperty
    protected Path path;
    @JsonProperty
    protected long size;

    public ResourceStruct(ResourcesFactory factory, ResourceModel model) {
        this.name = model.getName();
        this.hash = model.getHash();
        this.size = model.getSize();
        this.path = factory.preparePath(model);
    }

    public ResourceStruct copyStruct() {
        return new ResourceStruct(this.name, this.hash, this.path, this.size);
    }

    public String getName() {
        return this.name;
    }

    public String getHash() {
        return this.hash;
    }

    public Path getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public void setHash(String hash) {
        this.hash = hash;
    }

    @JsonProperty
    public void setPath(Path path) {
        this.path = path;
    }

    @JsonProperty
    public void setSize(long size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceStruct)) {
            return false;
        }
        ResourceStruct other = (ResourceStruct)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Path this$path = this.getPath();
        Path other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceStruct;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    public String toString() {
        return "ResourceStruct(name=" + this.getName() + ", hash=" + this.getHash() + ", path=" + this.getPath() + ", size=" + this.getSize() + ")";
    }

    public ResourceStruct() {
    }

    public ResourceStruct(String name, String hash, Path path, long size) {
        this.name = name;
        this.hash = hash;
        this.path = path;
        this.size = size;
    }
}

