/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import ru.smclabs.slauncher.resources.exception.ResourceException;

public class CompressedUtils {
    public static void extract(Path archive, Path directoryTo) throws IOException {
        if (Files.notExists(archive, new LinkOption[0])) {
            throw new ResourceException("Archive " + archive + " does not exist.");
        }
        try {
            if (archive.getFileName().toString().endsWith(".zip")) {
                CompressedUtils.unzip(archive, directoryTo);
                return;
            }
        }
        catch (IOException eio) {
            throw new ResourceException("Failed to extract " + archive + " with using legacy method:", eio);
        }
        CompressedUtils.extractWithArchiver(archive, directoryTo);
    }

    private static void extractWithArchiver(Path archive, Path directoryTo) throws IOException {
        File archiveFile = archive.toFile();
        File directoryFile = directoryTo.toFile();
        Archiver archiver = ArchiverFactory.createArchiver(archiveFile);
        archiver.extract(archiveFile, directoryFile);
    }

    public static void unzip(Path zipArchive, Path dirTo) throws IOException {
        Files.createDirectories(dirTo, new FileAttribute[0]);
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(Files.newInputStream(zipArchive, new OpenOption[0]), 65536));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                CompressedUtils.unzipEntry(entry, zis, dirTo);
            }
        }
    }

    private static void unzipEntry(ZipEntry entry, ZipInputStream zipInputStream, Path dirTo) throws IOException {
        if (entry.isDirectory()) {
            return;
        }
        Path entryPath = dirTo.resolve(entry.getName()).normalize();
        if (!entryPath.startsWith(dirTo)) {
            throw new IOException("Invalid zip entry: " + entry.getName());
        }
        Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
        try (OutputStream fos = Files.newOutputStream(entryPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = zipInputStream.read(buffer)) > 0) {
                fos.write(buffer, 0, length);
            }
        }
    }
}

