/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.slauncher.resources.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import ru.smclabs.slauncher.resources.type.ResourceStruct;

public class FileUtils {
    public static String humanSize(long bytes) {
        long kilobytes = bytes / 1024L;
        if (kilobytes > 0x100000L) {
            return String.format("%.2f", Float.valueOf((float)kilobytes / 1024.0f * 1024.0f)) + " \u0413\u0411";
        }
        if (kilobytes > 1024L) {
            return String.format("%.1f", Float.valueOf((float)kilobytes / 1024.0f)) + " \u041c\u0411";
        }
        return kilobytes + " \u041a\u0411";
    }

    public static long size(Path file) {
        try {
            return Files.size(file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static void waitForAppears(Path path, int attempts) throws IOException {
        if (attempts <= 0) {
            throw new IllegalArgumentException("Attempts must be greater than 0");
        }
        for (int i = 0; i < attempts; ++i) {
            if (Files.exists(path, new LinkOption[0])) {
                return;
            }
            try {
                TimeUnit.SECONDS.sleep(i + 1);
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("Interruption while waiting: " + path, ie);
            }
        }
        throw new FileNotFoundException(path.toString());
    }

    private static void moveWithAttempts(Path source, Path destination, int attempts, CopyOption ... options) throws IOException {
        if (attempts <= 0) {
            throw new IllegalArgumentException("Attempts must be greater than 0");
        }
        IOException lastException = null;
        for (int i = 0; i < attempts; ++i) {
            try {
                Files.move(source, destination, options);
                return;
            }
            catch (AtomicMoveNotSupportedException ame) {
                throw ame;
            }
            catch (IOException ioe) {
                lastException = ioe;
                try {
                    TimeUnit.SECONDS.sleep(i + 1);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interruption while moving: " + source + " -> " + destination);
                }
            }
        }
        throw lastException;
    }

    public static Path move(Path source, Path destination, int attempts, CopyOption ... options) throws IOException {
        if (attempts <= 0) {
            throw new IllegalArgumentException("Attempts must be greater than 0");
        }
        FileUtils.waitForAppears(source, attempts);
        FileUtils.moveWithAttempts(source, destination, attempts, options);
        FileUtils.waitForAppears(destination, attempts);
        return destination;
    }

    public static Path atomicMove(Path source, Path destination, int attempts, CopyOption ... fallbackOptions) throws IOException {
        try {
            return FileUtils.move(source, destination, attempts, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            return FileUtils.move(source, destination, attempts, fallbackOptions);
        }
    }

    public static boolean equalsSizes(Path file, ResourceStruct resource) {
        return FileUtils.size(file) == resource.getSize();
    }

    public static boolean notEqualsSizes(Path file, ResourceStruct resource) {
        return !FileUtils.equalsSizes(file, resource);
    }

    public static void deleteFile(Path file) throws IOException {
        FileUtils.deleteFile(file, 5);
    }

    public static void deleteFile(Path file, int attempts) throws IOException {
        if (attempts <= 0) {
            throw new IllegalArgumentException("Attempts must be greater than 0");
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IOException("Is a not regular file: " + file);
        }
        IOException last = null;
        for (int attempt = 0; attempt < attempts; ++attempt) {
            try {
                Files.deleteIfExists(file);
                return;
            }
            catch (IOException eio) {
                last = eio;
                try {
                    TimeUnit.SECONDS.sleep(attempt + 1);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interruption while delete:" + file, ie);
                }
            }
        }
        throw last;
    }

    public static void deleteDir(Path path) throws IOException {
        FileUtils.deleteDir(path, predicatePath -> true);
    }

    public static void deleteDir(Path path, Predicate<Path> filter) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> files = Files.walk(path, new FileVisitOption[0]).filter(filter).sorted(Comparator.reverseOrder());){
                files.forEach(file -> {
                    try {
                        Files.deleteIfExists(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        } else {
            Files.deleteIfExists(path);
        }
    }
}

