/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.system;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import ru.smclabs.system.exception.SystemException;
import ru.smclabs.system.info.SystemInfo;
import ru.smclabs.system.windows.WindowsRegistryHelper;

public class SystemActions {
    private static Desktop getDesktop() throws SystemException {
        if (Desktop.isDesktopSupported()) {
            try {
                return Desktop.getDesktop();
            }
            catch (Throwable e) {
                throw new SystemException("Failed to get desktop!", e);
            }
        }
        throw new SystemException("Desktop not supported!");
    }

    public static void browse(String url) throws SystemException {
        try {
            SystemActions.browse(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new SystemException("Failed to browse URL: " + url, e);
        }
    }

    public static void browse(URL url) throws SystemException {
        try {
            SystemActions.getDesktop().browse(url.toURI());
        }
        catch (IOException | URISyntaxException e) {
            throw new SystemException("Failed to browse URL: " + url, e);
        }
    }

    public static void open(Path path) throws SystemException {
        SystemActions.open(path.toFile());
    }

    public static void open(File file) throws SystemException {
        try {
            SystemActions.getDesktop().open(file);
        }
        catch (IOException e) {
            throw new SystemException("Failed to open file: " + file.getPath(), e);
        }
    }

    public static void edit(Path path) throws SystemException {
        SystemActions.edit(path.toFile());
    }

    public static void edit(File file) throws SystemException {
        try {
            SystemActions.getDesktop().edit(file);
        }
        catch (IOException e) {
            throw new SystemException("Failed to edit file: " + file.getPath(), e);
        }
    }

    public static void setGpuPerformancePreference(Path path) throws SystemException {
        if (!SystemInfo.get().isWindows()) {
            return;
        }
        try {
            WindowsRegistryHelper.addKey(WindowsRegistryHelper.WRKey.HKCU, "Software\\Microsoft\\DirectX\\UserGpuPreferences");
            WindowsRegistryHelper.addValue(WindowsRegistryHelper.WRKey.HKCU, "Software\\Microsoft\\DirectX\\UserGpuPreferences", "\"" + path + "\"", "GpuPreference=2;".getBytes(), WindowsRegistryHelper.WRType.REG_SZ);
        }
        catch (IOException | InterruptedException e) {
            throw new SystemException("Failed to set GPU preference!", e);
        }
    }
}

