/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.system.info;

public class SystemInfo {
    private static final SystemInfo instance = new SystemInfo(System.getProperty("os.name", "Unknown"));
    private final String id;
    private final String name;
    private final boolean x64;

    public static SystemInfo get() {
        return instance;
    }

    private SystemInfo(String name) {
        this.name = name;
        this.id = this.defineId();
        this.x64 = this.testX64();
    }

    private String defineId() {
        if (this.name.toLowerCase().contains("win")) {
            return "windows";
        }
        if (this.name.toLowerCase().contains("linux") || this.name.toLowerCase().contains("unix")) {
            return "linux";
        }
        if (this.name.toLowerCase().contains("mac")) {
            return "macos";
        }
        return "unknown";
    }

    private boolean testX64() {
        if (this.isWindows()) {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            boolean isArm64 = "ARM64".equalsIgnoreCase(arch) || "ARM64".equalsIgnoreCase(wow64Arch);
            boolean isX64 = "AMD64".equalsIgnoreCase(arch) || "AMD64".equalsIgnoreCase(wow64Arch);
            return isArm64 || isX64;
        }
        return System.getProperty("os.arch").contains("64");
    }

    public boolean isI586() {
        return !this.x64;
    }

    public boolean isWindows() {
        return "windows".equals(this.id);
    }

    public boolean isLinux() {
        return "linux".equals(this.id);
    }

    public boolean isMacOS() {
        return "macos".equals(this.id);
    }

    public String toString() {
        return this.id + (this.x64 ? "-x64" : "-i586");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isX64() {
        return this.x64;
    }
}

