/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.system.process;

import java.io.IOException;
import java.util.StringTokenizer;
import ru.smclabs.system.exception.SystemException;
import ru.smclabs.system.info.SystemInfo;

public class ProcessActions {
    public static Process kill(long pid) throws SystemException {
        if (SystemInfo.get().isWindows()) {
            return ProcessActions.exec("cmd /c TASKKILL /F /PID " + pid);
        }
        return ProcessActions.exec("kill -9 " + pid);
    }

    public static Process exec(String command) throws SystemException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(command);
            String[] cmd = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                cmd[i] = tokenizer.nextToken();
                ++i;
            }
            return new ProcessBuilder(cmd).start();
        }
        catch (IOException e) {
            throw new SystemException("Failed to execute: " + command, e);
        }
    }
}

