/*
 * Decompiled with CFR 0.152.
 */
package ru.smclabs.system.windows;

import java.io.IOException;

public class WindowsRegistryHelper {
    public static final int REG_SUCCESS = 0;

    public static String createRegString(WRKey wrKey, String key, String valueName, byte[] data, WRType type, boolean force) {
        String valueString;
        String keyString = " " + (Object)((Object)wrKey) + "\\" + key;
        String string = valueString = valueName != null ? " /v " + valueName : "";
        String dataString = data != null ? " " + (data.length > 0 ? " /d " + new String(data) : "") : "";
        String typeString = type != null ? " /t " + (Object)((Object)type) : "";
        return keyString + valueString + dataString + typeString + (force ? " /f" : "");
    }

    public static boolean addKey(WRKey wrKey, String key) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec("REG ADD " + (Object)((Object)wrKey) + "\\" + key + " /f");
        process.waitFor();
        return process.exitValue() == 0;
    }

    public static boolean addValue(WRKey wrKey, String key, String valueName, byte[] data, WRType type) throws IOException, InterruptedException {
        String regString = WindowsRegistryHelper.createRegString(wrKey, key, valueName, data, type, true);
        Process proc = Runtime.getRuntime().exec("REG ADD " + regString);
        proc.waitFor();
        return proc.exitValue() == 0;
    }

    public static enum WRKey {
        HKLM,
        HKCU,
        HKCR,
        HKU,
        HKCC;

    }

    public static enum WRType {
        REG_SZ,
        REG_MULTI_SZ,
        REG_EXPAND_SZ,
        REG_DWORD,
        REG_QWORD,
        REG_BINARY,
        REG_NONE;

    }
}

